clear; clc;
% evaluate nodal correlation

behavior=xlsread('/home/k1514724/subhadip/BBC/analysis/behavihoral_measures/arranged_Manesar_data_updated.xls');

% rsfMRI based global network measures

cd /home/k1514724/subhadip/BBC/analysis/network_measures/

rsfMRI_efficiency=load('rsfMRI_nodal_efficiency.txt');

% regress-out nuisances from the network measures
Z=[behavior(:,1) behavior(:,2) behavior(:,3)];
M=[ones(30,1) Z];
clear Z;

Y=rsfMRI_efficiency;
for n=1:90
b = M\Y(:,n);
res = Y(:,n) - M*b;
rsfMRI_efficiency(:,n)=res;
end
y=rsfMRI_efficiency;
clear Y; clear b; clear res;


% Permutation analysis
Permset=load('/home/k1514724/subhadip/BBC/analysis/correlation_analysis/codes/Permutation_sets.txt');

r_obs=[];
for region=1:90
for n=5:29
   [r_obs(region,n-4),useless]=corr(y(:,region),behavior(:,n),'type','spearman');
end
end

r_perm=[];
for region=1:90
    region
    y_region=y(:,region);
for m=2:10001
for n=5:29
   [r_perm(region,n-4,m-1),useless]=corr(y_region(Permset(:,m)),behavior(:,n),'type','spearman');
end
end

end

'efficiency'

p=[];
for region=1:90
for n=1:25
p(region,n)=min([(length(find(r_obs(region,n)>r_perm(region,n,:)))+1)/10000 (length(find(r_obs(region,n)<r_perm(region,n,:)))+1)/10000 ]);
end
end


BrainRegion_Names={'Precentral_L';
'Precentral_R';
'Frontal_Sup_L';
'Frontal_Sup_R';
'Frontal_Sup_Orb_L';
'Frontal_Sup_Orb_R';
'Frontal_Mid_L';
'Frontal_Mid_R';
'Frontal_Mid_Orb_L';
'Frontal_Mid_Orb_R';
'Frontal_Inf_Oper_L';
'Frontal_Inf_Oper_R';
'Frontal_Inf_Tri_L';
'Frontal_Inf_Tri_R';
'Frontal_Inf_Orb_L';
'Frontal_Inf_Orb_R';
'Rolandic_Oper_L';
'Rolandic_Oper_R';
'Supp_Motor_Area_L';
'Supp_Motor_Area_R';
'Olfactory_L';
'Olfactory_R';
'Frontal_Sup_Medial_L';
'Frontal_Sup_Medial_R';
'Frontal_Med_Orb_L';
'Frontal_Med_Orb_R';
'Rectus_L';
'Rectus_R';
'Insula_L';
'Insula_R';
'Cingulum_Ant_L';
'Cingulum_Ant_R';
'Cingulum_Mid_L';
'Cingulum_Mid_R';
'Cingulum_Post_L';
'Cingulum_Post_R';
'Hippocampus_L';
'Hippocampus_R';
'ParaHippocampal_L';
'ParaHippocampal_R';
'Amygdala_L';
'Amygdala_R';
'Calcarine_L';
'Calcarine_R';
'Cuneus_L';
'Cuneus_R';
'Lingual_L';
'Lingual_R';
'Occipital_Sup_L';
'Occipital_Sup_R';
'Occipital_Mid_L';
'Occipital_Mid_R';
'Occipital_Inf_L';
'Occipital_Inf_R';
'Fusiform_L';
'Fusiform_R';
'Postcentral_L';
'Postcentral_R';
'Parietal_Sup_L';
'Parietal_Sup_R';
'Parietal_Inf_L';
'Parietal_Inf_R';
'SupraMarginal_L';
'SupraMarginal_R';
'Angular_L';
'Angular_R';
'Precuneus_L';
'Precuneus_R';
'Paracentral_Lobule_L';
'Paracentral_Lobule_R';
'Caudate_L';
'Caudate_R';
'Putamen_L';
'Putamen_R';
'Pallidum_L';
'Pallidum_R';
'Thalamus_L';
'Thalamus_R';
'Heschl_L';
'Heschl_R';
'Temporal_Sup_L';
'Temporal_Sup_R';
'Temporal_Pole_Sup_L';
'Temporal_Pole_Sup_R';
'Temporal_Mid_L';
'Temporal_Mid_R';
'Temporal_Pole_Mid_L';
'Temporal_Pole_Mid_R';
'Temporal_Inf_L';
'Temporal_Inf_R';}
Full_IQ=r_obs(:,1); Verbal_IQ=r_obs(:,2); Performance_IQ=r_obs(:,3); 
Item_1A=r_obs(:,4); Item_1B=r_obs(:,5);
Item_2A=r_obs(:,6); Item_2B=r_obs(:,7);
Item_3A=r_obs(:,8); Item_3B=r_obs(:,9);
Item_4A=r_obs(:,10); Item_4B=r_obs(:,11);
Item_5A=r_obs(:,12); Item_5B=r_obs(:,13);
EQ=r_obs(:,14); SQ=r_obs(:,15); SSQ_Total=r_obs(:,16); SRS=r_obs(:,17);
RMET_CORRECT=r_obs(:,18); COWA_TOTAL_Production=r_obs(:,19); AnNT_Production=r_obs(:,20);
FC_EFT_QAMean=r_obs(:,21); ANT_ALERT=r_obs(:,22); ANT_ORIENTING=r_obs(:,23);
ANT_CONFLICT=r_obs(:,24); ANT_GRANDMEAN=r_obs(:,25);

T=table(BrainRegion_Names,Full_IQ, Verbal_IQ, Performance_IQ, Item_1A, Item_1B, Item_2A, Item_2B, Item_3A, Item_3B, Item_4A, Item_4B, Item_5A, Item_5B, EQ, SQ, SSQ_Total, SRS, RMET_CORRECT, COWA_TOTAL_Production, AnNT_Production, FC_EFT_QAMean, ANT_ALERT, ANT_ORIENTING, ANT_CONFLICT, ANT_GRANDMEAN);
writetable(T,'FMRInodalnet_efficiency_correlation_coefficients.xls')
clear T;

Full_IQ=p(:,1); Verbal_IQ=p(:,2); Performance_IQ=p(:,3); 
Item_1A=p(:,4); Item_1B=p(:,5);
Item_2A=p(:,6); Item_2B=p(:,7);
Item_3A=p(:,8); Item_3B=p(:,9);
Item_4A=p(:,10); Item_4B=p(:,11);
Item_5A=p(:,12); Item_5B=p(:,13);
EQ=p(:,14); SQ=p(:,15); SSQ_Total=p(:,16); SRS=p(:,17);
RMET_CORRECT=p(:,18); COWA_TOTAL_Production=p(:,19); AnNT_Production=p(:,20);
FC_EFT_QAMean=p(:,21); ANT_ALERT=p(:,22); ANT_ORIENTING=p(:,23);
ANT_CONFLICT=p(:,24); ANT_GRANDMEAN=p(:,25);

T=table(BrainRegion_Names,Full_IQ, Verbal_IQ, Performance_IQ, Item_1A, Item_1B, Item_2A, Item_2B, Item_3A, Item_3B, Item_4A, Item_4B, Item_5A, Item_5B, EQ, SQ, SSQ_Total, SRS, RMET_CORRECT, COWA_TOTAL_Production, AnNT_Production, FC_EFT_QAMean, ANT_ALERT, ANT_ORIENTING, ANT_CONFLICT, ANT_GRANDMEAN);
writetable(T,'FMRInodalnet_efficiency_correlation_pvals.xls')
clear T;






