clear; clc;
% evaluate global correlation

behavior=xlsread('/home/k1514724/subhadip/BBC/analysis/behavihoral_measures/arranged_Manesar_data_updated.xls');

% dti based global network measures

cd /home/k1514724/subhadip/BBC/analysis/network_measures/

dti_clustcoef=load('dti_average_cluscoeff.txt');
dti_charpathlength=load('dti_global_charpathlength.txt');
dti_efficiency=load('dti_Eglob.txt');

fmri_clustcoef=load('rsfMRI_average_cluscoeff.txt');
fmri_charpathlength=load('rsfMRI_global_charpathlength.txt');
fmri_efficiency=load('rsfMRI_Eglob.txt');

% regress-out nuisances from the network measures
Z=[behavior(:,1) behavior(:,2) behavior(:,3)];
M=[ones(30,1) Z];
clear Z;

Y=dti_clustcoef;
b = M\Y;
res = Y - M*b;
dti_clustcoef=res;
clear Y; clear b; clear res;

Y=dti_charpathlength;
b = M\Y;
res = Y - M*b;
dti_charpathlength=res;
clear Y; clear b; clear res;

Y=dti_efficiency;
b = M\Y;
res = Y - M*b;
dti_efficiency=res;
clear Y; clear b; clear res;

Y=fmri_clustcoef;
b = M\Y;
res = Y - M*b;
fmri_clustcoef=res;
clear Y; clear b; clear res;

Y=fmri_charpathlength;
b = M\Y;
res = Y - M*b;
fmri_charpathlength=res;
clear Y; clear b; clear res;

Y=fmri_efficiency;
b = M\Y;
res = Y - M*b;
fmri_efficiency=res;
clear Y; clear b; clear res; 

Permset=load('/home/k1514724/subhadip/BBC/analysis/correlation_analysis/codes/Permutation_sets.txt');

% Permutation analysis: dti cluscoef
y=dti_clustcoef;
r_obs=[];
for n=5:29
   [r_obs(end+1),useless]=corr(y,behavior(:,n),'type','spearman');
end

r_perm=[];
for m=1:10000
for n=5:29
   [r_perm(m,n-4),useless]=corr(y(Permset(:,m)),behavior(:,n),'type','spearman');
end
end

p=[];
for n=1:25
p(end+1)=min([(length(find(r_obs(1,n)>r_perm(:,n)))+1)/10000 (length(find(r_obs(1,n)<r_perm(:,n)))+1)/10000 ]);
end

r1=r_obs;
p1=p;
    
clear r_obs; clear p; clear r_perm;clear y;

% Permutation analysis: dti charpathlength
y=dti_charpathlength;
r_obs=[];
for n=5:29
   [r_obs(end+1),useless]=corr(y,behavior(:,n),'type','spearman');
end

r_perm=[];
for m=1:10000
for n=5:29
   [r_perm(m,n-4),useless]=corr(y(Permset(:,m)),behavior(:,n),'type','spearman');
end
end

p=[];
for n=1:25
p(end+1)=min([(length(find(r_obs(1,n)>r_perm(:,n)))+1)/10000 (length(find(r_obs(1,n)<r_perm(:,n)))+1)/10000 ]);
end

r2=r_obs;
p2=p;
    
clear r_obs; clear p; clear r_perm;clear y;


% Permutation analysis: dti efficiency
y=dti_efficiency;
r_obs=[];
for n=5:29
   [r_obs(end+1),useless]=corr(y,behavior(:,n),'type','spearman');
end

r_perm=[];
for m=1:10000
for n=5:29
   [r_perm(m,n-4),useless]=corr(y(Permset(:,m)),behavior(:,n),'type','spearman');
end
end

p=[];
for n=1:25
p(end+1)=min([(length(find(r_obs(1,n)>r_perm(:,n)))+1)/10000 (length(find(r_obs(1,n)<r_perm(:,n)))+1)/10000 ]);
end

r3=r_obs;
p3=p;
    
clear r_obs; clear p; clear r_perm;clear y;

% Permutation analysis: fmri cluscoef
y=fmri_clustcoef;
r_obs=[];
for n=5:29
   [r_obs(end+1),useless]=corr(y,behavior(:,n),'type','spearman');
end

r_perm=[];
for m=1:10000
for n=5:29
   [r_perm(m,n-4),useless]=corr(y(Permset(:,m)),behavior(:,n),'type','spearman');
end
end

p=[];
for n=1:25
p(end+1)=min([(length(find(r_obs(1,n)>r_perm(:,n)))+1)/10000 (length(find(r_obs(1,n)<r_perm(:,n)))+1)/10000 ]);
end

r4=r_obs;
p4=p;
    
clear r_obs; clear p; clear r_perm;clear y;

% Permutation analysis: fmri charpathlength
y=fmri_charpathlength;
r_obs=[];
for n=5:29
   [r_obs(end+1),useless]=corr(y,behavior(:,n),'type','spearman');
end

r_perm=[];
for m=1:10000
for n=5:29
   [r_perm(m,n-4),useless]=corr(y(Permset(:,m)),behavior(:,n),'type','spearman');
end
end

p=[];
for n=1:25
p(end+1)=min([(length(find(r_obs(1,n)>r_perm(:,n)))+1)/10000 (length(find(r_obs(1,n)<r_perm(:,n)))+1)/10000 ]);
end

r5=r_obs;
p5=p;
    
clear r_obs; clear p; clear r_perm;clear y;


% Permutation analysis: fmri efficiency
y=fmri_efficiency;
r_obs=[];
for n=5:29
   [r_obs(end+1),useless]=corr(y,behavior(:,n),'type','spearman');
end

r_perm=[];
for m=1:10000
for n=5:29
   [r_perm(m,n-4),useless]=corr(y(Permset(:,m)),behavior(:,n),'type','spearman');
end
end

p=[];
for n=1:25
p(end+1)=min([(length(find(r_obs(1,n)>r_perm(:,n)))+1)/10000 (length(find(r_obs(1,n)<r_perm(:,n)))+1)/10000 ]);
end

r6=r_obs;
p6=p;
    
clear r_obs; clear p; clear r_perm;clear y;

%------------------------
% Make tables
%------------------------
% DTI Correlation coefficient

dti_corrvals=[r1; r2; r3];

Global_MRINet_Measures={'dti_ClusterinCoefficient';'dti_CharacterPathLength'; 'dti_Efficiency'};

Full_IQ=dti_corrvals(:,1); Verbal_IQ=dti_corrvals(:,2); Performance_IQ=dti_corrvals(:,3); 
Item_1A=dti_corrvals(:,4); Item_1B=dti_corrvals(:,5);
Item_2A=dti_corrvals(:,6); Item_2B=dti_corrvals(:,7);
Item_3A=dti_corrvals(:,8); Item_3B=dti_corrvals(:,9);
Item_4A=dti_corrvals(:,10); Item_4B=dti_corrvals(:,11);
Item_5A=dti_corrvals(:,12); Item_5B=dti_corrvals(:,13);
EQ=dti_corrvals(:,14); SQ=dti_corrvals(:,15); SSQ_Total=dti_corrvals(:,16); SRS=dti_corrvals(:,17);
RMET_CORRECT=dti_corrvals(:,18); COWA_TOTAL_Production=dti_corrvals(:,19); AnNT_Production=dti_corrvals(:,20);
FC_EFT_QAMean=dti_corrvals(:,21); ANT_ALERT=dti_corrvals(:,22); ANT_ORIENTING=dti_corrvals(:,23);
ANT_CONFLICT=dti_corrvals(:,24); ANT_GRANDMEAN=dti_corrvals(:,25);
T=table(Global_MRINet_Measures,Full_IQ, Verbal_IQ, Performance_IQ, Item_1A, Item_1B, Item_2A, Item_2B, Item_3A, Item_3B, Item_4A, Item_4B, Item_5A, Item_5B, EQ, SQ, SSQ_Total, SRS, RMET_CORRECT, COWA_TOTAL_Production, AnNT_Production, FC_EFT_QAMean, ANT_ALERT, ANT_ORIENTING, ANT_CONFLICT, ANT_GRANDMEAN);
writetable(T,'DTIglobalnet_correlation_coefficient.xls')
clear T;

% DTI Correlation pvals

dti_pvals=[p1; p2; p3];

Global_MRINet_Measures={'dti_ClusterinCoefficient';'dti_CharacterPathLength'; 'dti_Efficiency'};

Full_IQ=dti_pvals(:,1); Verbal_IQ=dti_pvals(:,2); Performance_IQ=dti_pvals(:,3); 
Item_1A=dti_pvals(:,4); Item_1B=dti_pvals(:,5);
Item_2A=dti_pvals(:,6); Item_2B=dti_pvals(:,7);
Item_3A=dti_pvals(:,8); Item_3B=dti_pvals(:,9);
Item_4A=dti_pvals(:,10); Item_4B=dti_pvals(:,11);
Item_5A=dti_pvals(:,12); Item_5B=dti_pvals(:,13);
EQ=dti_pvals(:,14); SQ=dti_pvals(:,15); SSQ_Total=dti_pvals(:,16); SRS=dti_pvals(:,17);
RMET_CORRECT=dti_pvals(:,18); COWA_TOTAL_Production=dti_pvals(:,19); AnNT_Production=dti_pvals(:,20);
FC_EFT_QAMean=dti_pvals(:,21); ANT_ALERT=dti_pvals(:,22); ANT_ORIENTING=dti_pvals(:,23);
ANT_CONFLICT=dti_pvals(:,24); ANT_GRANDMEAN=dti_pvals(:,25);
T=table(Global_MRINet_Measures,Full_IQ, Verbal_IQ, Performance_IQ, Item_1A, Item_1B, Item_2A, Item_2B, Item_3A, Item_3B, Item_4A, Item_4B, Item_5A, Item_5B, EQ, SQ, SSQ_Total, SRS, RMET_CORRECT, COWA_TOTAL_Production, AnNT_Production, FC_EFT_QAMean, ANT_ALERT, ANT_ORIENTING, ANT_CONFLICT, ANT_GRANDMEAN);
writetable(T,'DTIglobalnet_correlation_pvals.xls')

% fmri Correlation coefficient

fmri_corrvals=[r4; r5; r6];

Global_MRINet_Measures={'fmri_ClusterinCoefficient';'fmri_CharacterPathLength'; 'fmri_Efficiency'};

Full_IQ=fmri_corrvals(:,1); Verbal_IQ=fmri_corrvals(:,2); Performance_IQ=fmri_corrvals(:,3); 
Item_1A=fmri_corrvals(:,4); Item_1B=fmri_corrvals(:,5);
Item_2A=fmri_corrvals(:,6); Item_2B=fmri_corrvals(:,7);
Item_3A=fmri_corrvals(:,8); Item_3B=fmri_corrvals(:,9);
Item_4A=fmri_corrvals(:,10); Item_4B=fmri_corrvals(:,11);
Item_5A=fmri_corrvals(:,12); Item_5B=fmri_corrvals(:,13);
EQ=fmri_corrvals(:,14); SQ=fmri_corrvals(:,15); SSQ_Total=fmri_corrvals(:,16); SRS=fmri_corrvals(:,17);
RMET_CORRECT=fmri_corrvals(:,18); COWA_TOTAL_Production=fmri_corrvals(:,19); AnNT_Production=fmri_corrvals(:,20);
FC_EFT_QAMean=fmri_corrvals(:,21); ANT_ALERT=fmri_corrvals(:,22); ANT_ORIENTING=fmri_corrvals(:,23);
ANT_CONFLICT=fmri_corrvals(:,24); ANT_GRANDMEAN=fmri_corrvals(:,25);
T=table(Global_MRINet_Measures,Full_IQ, Verbal_IQ, Performance_IQ, Item_1A, Item_1B, Item_2A, Item_2B, Item_3A, Item_3B, Item_4A, Item_4B, Item_5A, Item_5B, EQ, SQ, SSQ_Total, SRS, RMET_CORRECT, COWA_TOTAL_Production, AnNT_Production, FC_EFT_QAMean, ANT_ALERT, ANT_ORIENTING, ANT_CONFLICT, ANT_GRANDMEAN);
writetable(T,'FMRIglobalnet_correlation_coefficients.xls')
clear T;

% fmri Correlation pvals

fmri_pvals=[p4; p5; p6];

Global_MRINet_Measures={'fmri_ClusterinCoefficient';'fmri_CharacterPathLength'; 'fmri_Efficiency'};

Full_IQ=fmri_pvals(:,1); Verbal_IQ=fmri_pvals(:,2); Performance_IQ=fmri_pvals(:,3); 
Item_1A=fmri_pvals(:,4); Item_1B=fmri_pvals(:,5);
Item_2A=fmri_pvals(:,6); Item_2B=fmri_pvals(:,7);
Item_3A=fmri_pvals(:,8); Item_3B=fmri_pvals(:,9);
Item_4A=fmri_pvals(:,10); Item_4B=fmri_pvals(:,11);
Item_5A=fmri_pvals(:,12); Item_5B=fmri_pvals(:,13);
EQ=fmri_pvals(:,14); SQ=fmri_pvals(:,15); SSQ_Total=fmri_pvals(:,16); SRS=fmri_pvals(:,17);
RMET_CORRECT=fmri_pvals(:,18); COWA_TOTAL_Production=fmri_pvals(:,19); AnNT_Production=fmri_pvals(:,20);
FC_EFT_QAMean=fmri_pvals(:,21); ANT_ALERT=fmri_pvals(:,22); ANT_ORIENTING=fmri_pvals(:,23);
ANT_CONFLICT=fmri_pvals(:,24); ANT_GRANDMEAN=fmri_pvals(:,25);
T=table(Global_MRINet_Measures,Full_IQ, Verbal_IQ, Performance_IQ, Item_1A, Item_1B, Item_2A, Item_2B, Item_3A, Item_3B, Item_4A, Item_4B, Item_5A, Item_5B, EQ, SQ, SSQ_Total, SRS, RMET_CORRECT, COWA_TOTAL_Production, AnNT_Production, FC_EFT_QAMean, ANT_ALERT, ANT_ORIENTING, ANT_CONFLICT, ANT_GRANDMEAN);
writetable(T,'FMRIglobalnet_correlation_pvals.xls')
clear T

