clear;clc;

cd /home/subhadip/Autism_AnatNet/austistic_study/Diffusion_Analysis/90_regions
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%specify the total number of subjects
N=21;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% %Parellalize the processing
% [status currdir] = system([ ' FSLMACHINELIST="machine1 machine1 machine1 machine1 machine1 machine1 machine1" ' ])
% [status currdir] = system([ ' FSLREMOTECALL=ssh ' ])
% [status currdir] = system([ ' export FSLMACHINELIST FSLREMOTECALL ' ])

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%specify the bedpostx directories
chk=dir('*.bedpostX');

%specify the nodif_brain_masks

nodif_brainmasks=dir('nodif_brain_mask*.nii.gz');

% specify the aal masks warped on the subject space. It has been assumed
% that the warped aal masks for all subjects contain equal number of
% regions.
warpedaal_masks=dir('aal90_on_b0*.nii');

% count the number of regions in aal mask
temp=load_untouch_nii(warpedaal_masks(1).name);
total_regions=length(unique(temp.img))-1; % '-1' has been used to neglect the background zero intensity
clear temp ; 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Loop over the subjects
for m=25%:2%:N
    
 tic  
 
 basename=strcat('/home/subhadip/Autism_AnatNet/austistic_study/Diffusion_Analysis/90_regions/',chk(m).name , '/merged' )
 outputdir=strcat('/home/subhadip/Autism_AnatNet/austistic_study/Diffusion_Analysis/90_regions/',chk(m).name )
 brainmask=strcat('/home/subhadip/Autism_AnatNet/austistic_study/Diffusion_Analysis/90_regions/',nodif_brainmasks(m).name  )
 targetmask=strcat(outputdir,'/targetfile_folder/targetmask.txt')
% Load the warped aal mask for m-th subject   
temp=load_untouch_nii(warpedaal_masks(m).name);  
temp_aal=load_untouch_nii(warpedaal_masks(m).name); 

% Now split the regions of the warped aal mak of the m-th subject and save
% those regions as seperate files (region01.nii.gz, region02.nii.gz...)

  for region = 1:90
      
  matrix=temp.img;
  matrix(matrix<(region))=0;
  matrix(matrix>(region))=0;
  
  temp_aal.img=matrix;
  ch1=num2str(region,'%03d');
  region_file=strcat(outputdir,'/region', ch1, '.nii');
  save_untouch_nii(temp_aal, region_file);
  [status currdir] = system(['fslchfiletype NIFTI_GZ ' region_file ]);
  end

  clear region_file ; clear matrix;

  clear temp ; clear temp_aal ;  
  
%   Loop over the regions
  
 for region = 1:total_regions

  ch1=num2str(region,'%03d');
  region_file=strcat('region', ch1, '.nii.gz');
  region_file_path = strcat(outputdir,'/',region_file ) ;

  [status currdir] = system(['probtrackx --mode=seedmask -x ' region_file_path ' -l -c 0.2 -S 2000 --steplength=0.5 -P 5000 --forcedir  -s ' basename ' -m ' brainmask ' --dir=' outputdir ' --targetmasks=' targetmask ' --os2t --s2tastext '])
%   [status currdir] = system(['probtrackx --mode=seedmask -x ' region_file_path ' -l -c 0.2 -S 2000 --steplength=0.5 -P 5000 --forcedir  -s ' basename ' -m ' brainmask ' --dir=' outputdir ' --targetmasks=/home/subhadip/Tumor_Network/Data/analysis/990_regions/targetfile.txt --os2t --s2tastext==/home/subhadip/Tumor_Network/Data/analysis/990_regions/chk.txt '])
  


% renaming the fibrecount files
  temp_path=strcat ('/home/subhadip/Autism_AnatNet/austistic_study/Diffusion_Analysis/90_regions/', chk(m).name , '/');
  filename=strcat(temp_path,'matrix_seeds_to_all_targets');
  ch1=num2str(region,'%03d');
  newfilename=strcat(temp_path, 'region_', ch1 ,'_connections.txt');
%   newfilepath=strcat(newoutputdir , '/' , newfilename);
  M=load(filename);
  fid=fopen(newfilename , 'w');
  fprintf(fid,[repmat('%g ',1,size(M,2)),'\n'], M);
  fclose(fid); 
 end
% clear basename ; clear brainmask ; 
 toc
end
